/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandlerInsertionQuery {
    private final IItemHandler inventory;
    private final int size;
    private final List<ItemStack> items;
    private final NonNullList<ItemStack> inserted;
    private Insertion lastInsertion;
    private boolean committed;

    public static PrimitiveIterator.OfInt defaultVisitOrder(int size) {
        return IntStream.range(0, size).iterator();
    }

    public ItemHandlerInsertionQuery(IItemHandler inventory) {
        this.inventory = inventory;
        this.size = inventory.getSlots();
        this.items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.size; ++i) {
            this.items.add(null);
        }
        this.inserted = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
    }

    public Insertion insert(ItemStack stack) {
        return this.insert(stack, ItemHandlerInsertionQuery.defaultVisitOrder(this.size));
    }

    public Insertion insert(ItemStack stack, PrimitiveIterator.OfInt visitOrder) {
        stack = stack.m_41777_();
        int maxStackSize = stack.m_41741_();
        NonNullList insertedStacks = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
        while (visitOrder.hasNext()) {
            ItemStack totalLeftover;
            int i = visitOrder.nextInt();
            if (!this.couldInsert(i, stack)) continue;
            ItemStack alreadyInserted = (ItemStack)this.inserted.get(i);
            int maxInserted = Math.min(maxStackSize - alreadyInserted.m_41613_(), stack.m_41613_());
            ItemStack totalInserted = stack.m_41777_();
            totalInserted.m_41764_(alreadyInserted.m_41613_() + maxInserted);
            ItemStack itemStack = totalLeftover = totalInserted.m_41619_() ? ItemStack.f_41583_ : this.inventory.insertItem(i, totalInserted, true);
            if (totalLeftover.m_41613_() > maxInserted) continue;
            int totalInsertedAmt = totalInserted.m_41613_() - totalLeftover.m_41613_();
            int insertedAmt = totalInsertedAmt - alreadyInserted.m_41613_();
            insertedStacks.set(i, (Object)stack.m_41620_(insertedAmt));
        }
        this.lastInsertion = new Insertion(stack, (NonNullList<ItemStack>)insertedStacks);
        return this.lastInsertion;
    }

    public void commit() {
        if (this.committed) {
            throw new IllegalStateException("This query has already been committed.");
        }
        this.committed = true;
        for (int i = 0; i < this.size; ++i) {
            ItemStack stack = (ItemStack)this.inserted.get(i);
            if (stack.m_41619_()) continue;
            this.inventory.insertItem(i, stack, false);
        }
    }

    private boolean couldInsert(int slot, ItemStack stack) {
        ItemStack currentItem = this.items.get(slot);
        if (currentItem == null) {
            currentItem = this.inventory.getStackInSlot(slot).m_41777_();
            this.items.set(slot, currentItem);
        }
        if (currentItem.m_41619_()) {
            return true;
        }
        if (currentItem.m_41613_() >= currentItem.m_41741_()) {
            return false;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)currentItem, (ItemStack)stack);
    }

    public class Insertion {
        private final ItemStack leftover;
        private final NonNullList<ItemStack> insertedStacks;

        private Insertion(ItemStack leftover, NonNullList<ItemStack> insertedStacks) {
            this.leftover = leftover;
            this.insertedStacks = insertedStacks;
        }

        public ItemStack getLeftover() {
            return this.leftover;
        }

        public void commit() {
            if (ItemHandlerInsertionQuery.this.lastInsertion != this) {
                throw new IllegalStateException("Only the most recent insertion can be committed.");
            }
            ItemHandlerInsertionQuery.this.lastInsertion = null;
            for (int i = 0; i < ItemHandlerInsertionQuery.this.size; ++i) {
                ItemStack stack = (ItemStack)this.insertedStacks.get(i);
                if (stack.m_41619_()) continue;
                ItemStack currentItem = ItemHandlerInsertionQuery.this.items.get(i);
                if (currentItem.m_41619_()) {
                    ItemHandlerInsertionQuery.this.items.set(i, stack);
                } else {
                    currentItem.m_41769_(stack.m_41613_());
                }
                ItemStack currentlyInserted = (ItemStack)ItemHandlerInsertionQuery.this.inserted.get(i);
                if (currentlyInserted.m_41619_()) {
                    ItemHandlerInsertionQuery.this.inserted.set(i, (Object)stack);
                    continue;
                }
                currentlyInserted.m_41769_(stack.m_41613_());
            }
        }
    }
}

